/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.structures.city;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import paulevs.betternether.world.structures.city.BoundingBox2D;
import paulevs.betternether.world.structures.city.StructureCityBuilding;
import paulevs.betternether.world.structures.city.palette.CityPalette;
import paulevs.betternether.world.structures.piece.CityPiece;

public class CityGenerator {
    private List<StructureCityBuilding> centers = new ArrayList<StructureCityBuilding>();
    private List<StructureCityBuilding> buildings = new ArrayList<StructureCityBuilding>();
    private List<StructureCityBuilding> roadEnds = new ArrayList<StructureCityBuilding>();
    private List<StructureCityBuilding> total = new ArrayList<StructureCityBuilding>();
    private List<BoundingBox2D> bounds = new ArrayList<BoundingBox2D>();
    private List<class_2338> ends = new ArrayList<class_2338>();
    private List<class_2338> add = new ArrayList<class_2338>();
    private List<class_2338> rem = new ArrayList<class_2338>();

    public CityGenerator() {
        this.addBuildingToList("city_center_01", -10, this.centers);
        this.addBuildingToList("city_center_02", -10, this.centers);
        this.addBuildingToList("city_center_03", -10, this.centers);
        this.addBuildingToList("city_center_04", -10, this.centers);
        this.addBuildingToList("city_library_01", this.buildings);
        this.addBuildingToList("city_library_02", this.buildings);
        this.addBuildingToList("city_tower_01", this.buildings);
        this.addBuildingToList("city_tower_02", this.buildings);
        this.addBuildingToList("city_tower_03", this.buildings);
        this.addBuildingToList("city_tower_04", this.buildings);
        this.addBuildingToList("city_building_01", this.buildings);
        this.addBuildingToList("city_building_02", this.buildings);
        this.addBuildingToList("city_building_03", this.buildings);
        this.addBuildingToList("city_building_04", this.buildings);
        this.addBuildingToList("city_building_05", this.buildings);
        this.addBuildingToList("city_building_06", this.buildings);
        this.addBuildingToList("city_building_07", this.buildings);
        this.addBuildingToList("city_building_08", this.buildings);
        this.addBuildingToList("city_building_09", this.buildings);
        this.addBuildingToList("city_building_10", this.buildings);
        this.addBuildingToList("city_building_11", this.buildings);
        this.addBuildingToList("city_building_12", this.buildings);
        this.addBuildingToList("city_building_13", this.buildings);
        this.addBuildingToList("city_building_14", this.buildings);
        this.addBuildingToList("city_building_15", this.buildings);
        this.addBuildingToList("city_enchanter_01", this.buildings);
        this.addBuildingToList("city_enchanter_02", this.buildings);
        this.addBuildingToList("city_park_01", this.buildings);
        this.addBuildingToList("city_park_02", this.buildings);
        this.addBuildingToList("city_park_03", this.buildings);
        this.addBuildingToList("city_bridge_01", this.buildings);
        this.addBuildingToList("ramp_01", this.buildings);
        this.addBuildingToList("road_cross_01", this.buildings);
        this.addBuildingToList("road_end_01", this.roadEnds);
        this.addBuildingToList("road_end_02", -2, this.roadEnds);
        this.total.addAll(this.centers);
        this.total.addAll(this.buildings);
        this.total.addAll(this.roadEnds);
    }

    private void addBuildingToList(String name, List<StructureCityBuilding> buildings) {
        this.addBuildingToList(name, 0, buildings);
    }

    private void addBuildingToList(String name, int offsetY, List<StructureCityBuilding> buildings) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name, offsetY);
        buildings.add(building);
        buildings.add(building.getRotated(class_2470.field_11463));
        buildings.add(building.getRotated(class_2470.field_11464));
        buildings.add(building.getRotated(class_2470.field_11465));
    }

    private void placeCenterBuilding(class_2338 pos, StructureCityBuilding building, ArrayList<CityPiece> city, Random random, CityPalette palette) {
        BoundingBox2D bb = building.getBoungingBox().offset(pos);
        this.bounds.add(bb);
        city.add(new CityPiece(building, pos.method_10069(0, building.getYOffset(), 0), random.nextInt(), palette));
        for (int i = 0; i < building.getEndsCount(); ++i) {
            this.ends.add(pos.method_10081((class_2382)building.getOffsettedPos(i).method_10069(0, building.getYOffset(), 0)));
        }
    }

    private void attachBuildings(Random random, ArrayList<CityPiece> city, CityPalette palette) {
        for (class_2338 pos : this.ends) {
            boolean generate = true;
            for (int n = 0; n < 8 && generate; ++n) {
                int b = random.nextInt(this.buildings.size() >> 2) << 2;
                for (int r = 0; r < 4 && generate; ++r) {
                    int i;
                    StructureCityBuilding building = this.buildings.get(b | r);
                    int index = random.nextInt(building.getEndsCount());
                    class_2338 offset = building.getPos(index);
                    BoundingBox2D bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                    if (!this.noCollisions(bb)) continue;
                    boolean validHeight = true;
                    class_2338 npos = new class_2338(bb.x1, pos.method_10264() - offset.method_10264() + building.getYOffset(), bb.z1);
                    for (i = 0; i < building.getEndsCount(); ++i) {
                        if (i == index || npos.method_10264() + building.getOffsettedPos(i).method_10264() >= 32) continue;
                        validHeight = false;
                        break;
                    }
                    if (!validHeight) continue;
                    this.bounds.add(bb);
                    this.rem.add(pos);
                    for (i = 0; i < building.getEndsCount(); ++i) {
                        if (i == index) continue;
                        this.add.add(npos.method_10081((class_2382)building.getOffsettedPos(i)));
                    }
                    city.add(new CityPiece(building, npos, random.nextInt(), palette));
                    generate = false;
                }
            }
        }
        this.ends.removeAll(this.rem);
        this.ends.addAll(this.add);
        this.rem.clear();
        this.add.clear();
    }

    private void closeRoads(ArrayList<CityPiece> city, Random random, CityPalette palette) {
        block0: for (class_2338 pos : this.ends) {
            for (int n = 0; n < this.roadEnds.size(); ++n) {
                StructureCityBuilding building = this.roadEnds.get(n);
                class_2338 offset = building.getPos(0);
                BoundingBox2D bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                if (!this.noCollisions(bb)) continue;
                class_2338 npos = new class_2338(bb.x1, pos.method_10264() - offset.method_10264() + building.getYOffset(), bb.z1);
                this.bounds.add(bb);
                city.add(new CityPiece(building, npos, random.nextInt(), palette));
                continue block0;
            }
        }
        this.ends.clear();
        this.bounds.clear();
        this.rem.clear();
        this.add.clear();
    }

    public ArrayList<CityPiece> generate(class_2338 pos, Random random, CityPalette palette) {
        ArrayList<CityPiece> city = new ArrayList<CityPiece>();
        this.placeCenterBuilding(pos, this.centers.get(random.nextInt(this.centers.size())), city, random, palette);
        float rnd = random.nextFloat();
        rnd *= rnd;
        rnd *= rnd;
        int iterations = Math.round(2.0f + rnd * 2.0f);
        for (int i = 0; i < iterations; ++i) {
            this.attachBuildings(random, city, palette);
        }
        this.closeRoads(city, random, palette);
        return city;
    }

    private boolean noCollisions(BoundingBox2D bb) {
        for (BoundingBox2D b : this.bounds) {
            if (!bb.isColliding(b)) continue;
            return false;
        }
        return true;
    }

    public List<StructureCityBuilding> getBuildings() {
        return this.total;
    }
}

